 // '02 Main.cpp'
#include <windows.h>

 // Prototyp programu obsugi komunikatw
LRESULT CALLBACK WndProc (HWND hWindow, UINT iMessage, 
                          WPARAM wParam, LPARAM lParam);

 // "WinMain kontra main"
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInst, 
                    LPSTR lpCmdLine, int nShowCmd)
{
  // "Klasa okna"
 WNDCLASS	kWndClass;
	
  // Waciwoci wizualne
 kWndClass.hCursor       = LoadCursor (NULL, IDC_ARROW);
 kWndClass.hIcon         = LoadIcon (NULL, IDI_APPLICATION);
 kWndClass.hbrBackground = (HBRUSH) GetStockObject (WHITE_BRUSH);

  // Waciwoci systemowe
 kWndClass.hInstance     = hInstance;
 kWndClass.lpfnWndProc   = WndProc;
 kWndClass.lpszClassName = "02 Real time message loop";

  // Waciwoci dodatkowe
 kWndClass.lpszMenuName  = NULL;

 kWndClass.cbClsExtra = NULL;
 kWndClass.cbWndExtra = NULL;
 kWndClass.style      = NULL;

  // Prba rejestracji klasy
 if (!RegisterClass (&kWndClass))
 {
  return -1;
 }

  // "Okno"
 HWND hWindow;
  // Tworzenie okna
 hWindow = CreateWindow ("02 Real time message loop", 
                         "02 Real time message loop", 
                         WS_OVERLAPPEDWINDOW | WS_VISIBLE, CW_USEDEFAULT,
                         CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, 
                         NULL, NULL, hInstance, NULL);
 ShowWindow (hWindow, nShowCmd);

  // "Ptla komunikatw w czasie rzeczywistym"
 MSG kMessage;
  // Wejcie do ptli czasu rzeczywistego
 while (1)
 {
   // Zapytanie czy nie ma w kolejce oczekujcych komunikatw
  if (PeekMessage (&kMessage, hWindow, 0, 0, PM_REMOVE))
  {
   // Jeeli jest to WM_QUIT opu ptle
   if (WM_QUIT == kMessage.message)
   {
    break;
   }
   // Normalne przetwarzanie komunikatw
	 else
	 {
	  TranslateMessage (&kMessage);
	  DispatchMessage (&kMessage);
	 }
  }
  // Brak komunikatw, wykonuj nasz kod
  else
  {
   // Nic nie rb ...
  }
}

return 0L;
}

// "Program obsugi komunikatw"
LRESULT CALLBACK WndProc (HWND hWindow, UINT iMessage, 
                          WPARAM wParam, LPARAM lParam)
{
 switch (iMessage)
 {
 // Zamknij okno
 case WM_CLOSE:
  PostQuitMessage (0);
 break;

 default:
  return DefWindowProc (hWindow, iMessage, wParam, lParam);
 }
 return 0;
}

 

